% THIS MATLAB FILE PROVIDES THE PARAMETERS OF THE ELECTRICITY NETWORK IN GHANA

function mpc = Distribution_Network_Urban_UK

% MATPOWER Case Format : Version 2
mpc.version = '2';


%-----  Power Flow Data  -----%

% system MVA base
mpc.baseMVA = 100;

% bus data
% bus_i	type Pd	    Qd	    Gs	Bs	area Vm	   Va	baseKV	zone Vmax	Vmin
mpc.bus=[
	  1 1   0.0000   0.0000 0 0 1  1.0000 0 11 1  1.06  0.94
	  2 1   0.0000   0.0000 0 0 1  1.0000 0 11 1  1.06  0.94
	  3 1   0.0000   0.0000 0 0 1  1.0000 0 11 1  1.06  0.94
	  4 1   0.0000   0.0000 0 0 1  1.0000 0 11 1  1.06  0.94
	  5 1   0.0000   0.0000 0 0 1  1.0000 0 11 1  1.06  0.94
	  6 1   0.0000   0.0000 0 0 1  1.0000 0 11 1  1.06  0.94
	  7 3   0.0000   0.0000 0 0 1  1.0000 0 11 1  1.06  0.94
	  8 1   0.0000   0.0000 0 0 1  1.0000 0 11 1  1.06  0.94
	  9 1   0.0000   0.0000 0 0 1  1.0000 0 11 1  1.06  0.94
	 10 1   0.0000   0.0000 0 0 1  1.0000 0 11 1  1.06  0.94
	 11 1   0.0000   0.0000 0 0 1  0.9944 -6.407600e-02 11 1  1.06  0.94
	 12 1   0.1943   0.0639 0 0 1  0.9990 -1.131300e-02 11 1  1.06  0.94
	 13 1   0.4615   0.1517 0 0 1  0.9943 -6.375800e-02 11 1  1.06  0.94
	 14 1   0.6687   0.2198 0 0 1  0.9981 -2.366700e-02 11 1  1.06  0.94
	 15 1   0.3044   0.1001 0 0 1  0.9925 -8.696100e-02 11 1  1.06  0.94
	 16 1   0.0000   0.0000 0 0 1  0.9906 -1.104500e-01 11 1  1.06  0.94
	 17 1   0.5829   0.1916 0 0 1  0.9869 -1.550200e-01 11 1  1.06  0.94
	 18 1   0.0000   0.0000 0 0 1  0.9869 -1.554700e-01 11 1  1.06  0.94
	 19 1   0.0000   0.0000 0 0 1  0.9815 -2.011200e-01 11 1  1.06  0.94
	 20 1   0.4858   0.1597 0 0 1  0.9816 -2.010200e-01 11 1  1.06  0.94
	 21 1   0.0000   0.0000 0 0 1  0.9815 -2.012900e-01 11 1  1.06  0.94
	 22 1   1.0557   0.3470 0 0 1  0.9974 -3.200900e-02 11 1  1.06  0.94
	 23 1   0.5311   0.1746 0 0 1  0.9884 -1.373200e-01 11 1  1.06  0.94
	 24 1   0.1214   0.0399 0 0 1  0.9815 -2.012600e-01 11 1  1.06  0.94
	 25 1   0.8501   0.2794 0 0 1  0.9821 -2.002500e-01 11 1  1.06  0.94
	 26 1   0.6849   0.2251 0 0 1  0.9833 -1.988700e-01 11 1  1.06  0.94
	 27 1   0.0000   0.0000 0 0 1  0.9821 -2.002500e-01 11 1  1.06  0.94
	 28 1   0.3238   0.1064 0 0 1  0.9814 -2.071900e-01 11 1  1.06  0.94
	 29 1   0.0000   0.0000 0 0 1  0.9816 -2.072500e-01 11 1  1.06  0.94
	 30 1   0.2429   0.0798 0 0 1  0.9815 -2.071300e-01 11 1  1.06  0.94
	];

% branch data
%fbus tbus	r           x	    b	    rateA   B	C ratio	angle status angmin	angmax
mpc.branch=[
	 22  21   0.00364463   0.00185124 0.000000 6.949992e+00 8.339991e+00 8.339991 0.000000 0.000000 1 -360 360
	  7   2   0.00000030   0.00000030 0.000000 1.000000e+02 1.200000e+02 120.000027 0.000000 0.000000 1 -360 360
	  2   4   0.00000030   0.00000030 0.000000 1.000000e+02 1.200000e+02 120.000027 0.000000 0.000000 1 -360 360
	  4   5   0.00000060   0.00000060 0.000000 1.000000e+02 1.200000e+02 120.000027 0.000000 0.000000 1 -360 360
	 10   5   0.00000018   0.00000018 0.000000 1.000000e+02 1.200000e+02 120.000027 0.000000 0.000000 1 -360 360
	  8  10   0.00000035   0.00000035 0.000000 1.000000e+02 1.200000e+02 120.000027 0.000000 0.000000 1 -360 360
	 12   8   0.04198340   0.02408020 0.000000 6.949992e+00 8.339991e+00 8.339991 0.000000 0.000000 1 -360 360
	 12  14   0.04738520   0.02804300 0.000000 7.999998e+00 9.599998e+00 9.599998 0.000000 0.000000 1 -360 360
	 14  22   0.05515000   0.03185420 0.000000 6.850005e+00 8.220006e+00 8.220006 0.000000 0.000000 1 -360 360
	  1   7   0.00000030   0.00000030 0.000000 1.000000e+02 1.200000e+02 120.000027 0.000000 0.000000 1 -360 360
	  3   1   0.00000030   0.00000030 0.000000 1.000000e+02 1.200000e+02 120.000027 0.000000 0.000000 1 -360 360
	  9   3   0.00000018   0.00000018 0.000000 1.000000e+02 1.200000e+02 120.000027 0.000000 0.000000 1 -360 360
	  6   9   0.00000035   0.00000035 0.000000 1.000000e+02 1.200000e+02 120.000027 0.000000 0.000000 1 -360 360
	 11   6   0.10178300   0.05769150 0.000000 6.850005e+00 8.220006e+00 8.220006 0.000000 0.000000 1 -360 360
	 16  15   0.04173050   0.02425360 0.000000 6.850005e+00 8.220006e+00 8.220006 0.000000 0.000000 1 -360 360
	 23  16   0.04753960   0.02762980 0.000000 6.850005e+00 8.220006e+00 8.220006 0.000000 0.000000 1 -360 360
	 17  23   0.03624200   0.02106370 0.000000 6.850005e+00 8.220006e+00 8.220006 0.000000 0.000000 1 -360 360
	 18  17   0.00109855   0.00063847 0.000000 6.850005e+00 8.220006e+00 8.220006 0.000000 0.000000 1 -360 360
	 26  18   0.10739200   0.06241610 0.000000 6.850005e+00 8.220006e+00 8.220006 0.000000 0.000000 1 -360 360
	 25  26   0.05274880   0.01848930 0.000000 5.329991e+00 6.395990e+00 6.395990 0.000000 0.000000 1 -360 360
	 29  25   0.08238350   0.04788100 0.000000 6.850005e+00 8.220006e+00 8.220006 0.000000 0.000000 1 -360 360
	 29  28   0.05022660   0.01615920 0.000000 5.329991e+00 6.395990e+00 6.395990 0.000000 0.000000 1 -360 360
	 29  30   0.01554960   0.00422479 0.000000 6.850005e+00 8.220006e+00 8.220006 0.000000 0.000000 1 -360 360
	 20  25   0.07949330   0.02826310 0.000000 6.860007e+00 8.232009e+00 8.232009 0.000000 0.000000 1 -360 360
	 19  20   0.03035330   0.01134870 0.000000 1.286000e+01 1.543200e+01 15.432001 0.000000 0.000000 1 -360 360
	 21  19   0.04840060   0.01830580 0.000000 4.660008e+00 5.592010e+00 5.592010 0.000000 0.000000 1 -360 360
	 21  24   0.00591322   0.00160661 0.000000 6.850005e+00 8.220006e+00 8.220006 0.000000 0.000000 1 -360 360
	 25  27   0.05411350   0.01470250 0.000000 6.850005e+00 8.220006e+00 8.220006 0.000000 0.000000 1 -360 360
	 15  11   0.03780740   0.02197360 0.000000 6.850005e+00 8.220006e+00 8.220006 0.000000 0.000000 1 -360 360
	 11  13   0.02080580   0.00565289 0.000000 6.850005e+00 8.220006e+00 8.220006 0.000000 0.000000 1 -360 360
	];

% Generator data
% bus	Pg	    Qg	  Qmax Qmin	Vg   mBase status Pmax Pmin	Pc1	Pc2	Qc1min	
% Qc1max	Qc2min Qc2max ramp_acg	ramp_10	ramp_30	ramp_q  Apf
mpc.gen=[
	  7    6.546940 2.160928    1000 -1000 1 100 1 1000 -1000 0 0 0 0 0 0 0 0 0 0 0
	];

%% generator cost data
%	1	startup	shutdown	n	x1	y1	...	xn	yn
%	2	startup	shutdown	n	c(n-1)	...	c0
mpc.gencost = [2	0	0	2	0	0];

%% Coordinates 
mpc.coordinates = [
    -484 17;-484 18;-484 17;-484 18;-484 18;-484 17;-484 18;-484 18;
    -484 17;-484 18;-849 102;-653 -59;-831 96;-814 -138;-801 256;-891 264;
    -1087 177;-1089 180;-1305 81;-1305 142;-1209 -15;-1021 -90;-991 98;
    -1201 -4;-1466 278;-1417 170;-1550 332;-1460 -85;-1529 -46;-1548 -37
    ];

%-----  Demand data  -----
% Time series (MW)
mpc.demandP = [
    0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
    0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
    0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
    0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
    0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
    0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
    0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
    0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
    0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
    0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
    0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
    0.079832 0.064370 0.062106 0.062106 0.062106 0.062106 0.062106 0.060683 0.065470 0.085849 0.090636 0.093935 0.091024 0.091283 0.091800 0.088566 0.089213 0.091283 0.094194 0.107133 0.107780 0.103963 0.101699 0.087660
    0.173165 0.141225 0.136502 0.135373 0.137207 0.137348 0.137841 0.143552 0.180216 0.202214 0.203765 0.204752 0.207573 0.207291 0.204329 0.193612 0.195727 0.205739 0.245999 0.265952 0.264613 0.247973 0.232109 0.202144
    0.274756 0.221541 0.213748 0.213748 0.213748 0.213748 0.213748 0.208850 0.225326 0.295463 0.311939 0.323294 0.313275 0.314166 0.315947 0.304814 0.307041 0.314166 0.324185 0.368716 0.370942 0.357806 0.350013 0.301697
    0.114228 0.093159 0.090043 0.089299 0.090508 0.090601 0.090927 0.094694 0.118879 0.133391 0.134414 0.135065 0.136925 0.136739 0.134786 0.127716 0.129112 0.135716 0.162273 0.175436 0.174552 0.163576 0.153111 0.133344
    0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
    0.218735 0.178390 0.172423 0.170998 0.173314 0.173492 0.174115 0.181329 0.227641 0.255428 0.257388 0.258635 0.262197 0.261841 0.258100 0.244563 0.247235 0.259881 0.310736 0.335940 0.334248 0.313229 0.293190 0.255339
    0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
    0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
    0.182279 0.148658 0.143686 0.142498 0.144428 0.144576 0.145096 0.151108 0.189701 0.212857 0.214490 0.215529 0.218498 0.218201 0.215084 0.203802 0.206029 0.216568 0.258946 0.279950 0.278540 0.261024 0.244325 0.212783
    0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
    0.433756 0.349746 0.337444 0.337444 0.337444 0.337444 0.337444 0.329710 0.355722 0.466445 0.492457 0.510383 0.494566 0.495972 0.498784 0.481209 0.484724 0.495972 0.511789 0.582090 0.585605 0.564866 0.552564 0.476287
    0.199292 0.162533 0.157097 0.155798 0.157908 0.158070 0.158638 0.165211 0.207406 0.232724 0.234509 0.235645 0.238891 0.238566 0.235158 0.222824 0.225258 0.236781 0.283115 0.306079 0.304537 0.285387 0.267129 0.232642
    0.045570 0.037165 0.035922 0.035625 0.036107 0.036144 0.036274 0.037777 0.047425 0.053214 0.053623 0.053882 0.054624 0.054550 0.053771 0.050951 0.051507 0.054142 0.064737 0.069988 0.069635 0.065256 0.061081 0.053196
    0.318989 0.260153 0.251451 0.249372 0.252749 0.253009 0.253918 0.264439 0.331977 0.372500 0.375357 0.377176 0.382371 0.381851 0.376396 0.356654 0.360551 0.378994 0.453156 0.489913 0.487445 0.456793 0.427570 0.372370
    0.257014 0.209609 0.202597 0.200923 0.203644 0.203853 0.204586 0.213062 0.267479 0.300129 0.302431 0.303896 0.308082 0.307663 0.303268 0.287362 0.290501 0.305361 0.365115 0.394730 0.392741 0.368045 0.344499 0.300024
    0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
    0.121520 0.099106 0.095791 0.094999 0.096285 0.096384 0.096731 0.100739 0.126467 0.141905 0.142993 0.143686 0.145665 0.145467 0.143389 0.135868 0.137353 0.144379 0.172631 0.186633 0.185693 0.174016 0.162884 0.141855
    0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
    0.091140 0.074329 0.071843 0.071249 0.072214 0.072288 0.072548 0.075554 0.094851 0.106429 0.107245 0.107765 0.109249 0.109101 0.107542 0.101901 0.103015 0.108284 0.129473 0.139975 0.139270 0.130512 0.122163 0.106392
    ];

% Time series (MVAR)
mpc.demandQ = [
    0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
    0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
    0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
    0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
    0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
    0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
    0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
    0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
    0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
    0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
    0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
    0.026240 0.021158 0.020413 0.020413 0.020413 0.020413 0.020413 0.019945 0.021519 0.028217 0.029791 0.030875 0.029918 0.030003 0.030173 0.029110 0.029323 0.030003 0.030960 0.035213 0.035426 0.034171 0.033427 0.028812
    0.056917 0.046419 0.044866 0.044495 0.045098 0.045144 0.045306 0.047183 0.059234 0.066465 0.066974 0.067299 0.068226 0.068133 0.067160 0.063637 0.064333 0.067623 0.080856 0.087414 0.086974 0.081505 0.076291 0.066441
    0.090308 0.072817 0.070256 0.070256 0.070256 0.070256 0.070256 0.068646 0.074061 0.097114 0.102530 0.106262 0.102969 0.103261 0.103847 0.100188 0.100920 0.103261 0.106555 0.121191 0.121923 0.117605 0.115044 0.099163
    0.037545 0.030620 0.029596 0.029351 0.029749 0.029779 0.029886 0.031125 0.039074 0.043843 0.044180 0.044394 0.045005 0.044944 0.044302 0.041978 0.042437 0.044608 0.053337 0.057663 0.057373 0.053765 0.050325 0.043828
    0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
    0.071895 0.058634 0.056673 0.056204 0.056965 0.057024 0.057229 0.059600 0.074822 0.083955 0.084599 0.085009 0.086180 0.086063 0.084833 0.080384 0.081262 0.085419 0.102134 0.110418 0.109862 0.102954 0.096367 0.083926
    0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
    0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
    0.059912 0.048862 0.047227 0.046837 0.047471 0.047520 0.047691 0.049667 0.062352 0.069963 0.070499 0.070841 0.071817 0.071719 0.070695 0.066987 0.067718 0.071182 0.085112 0.092015 0.091552 0.085795 0.080306 0.069938
    0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
    0.142568 0.114956 0.110912 0.110912 0.110912 0.110912 0.110912 0.108370 0.116920 0.153313 0.161862 0.167754 0.162555 0.163017 0.163942 0.158165 0.159320 0.163017 0.168216 0.191323 0.192478 0.185662 0.181618 0.156548
    0.065504 0.053422 0.051635 0.051209 0.051902 0.051955 0.052142 0.054302 0.068171 0.076493 0.077080 0.077453 0.078520 0.078413 0.077293 0.073239 0.074039 0.077826 0.093056 0.100603 0.100097 0.093802 0.087801 0.076466
    0.014978 0.012215 0.011807 0.011709 0.011868 0.011880 0.011923 0.012417 0.015588 0.017491 0.017625 0.017710 0.017954 0.017930 0.017674 0.016747 0.016930 0.017796 0.021278 0.023004 0.022888 0.021449 0.020076 0.017485
    0.104847 0.085508 0.082648 0.081965 0.083075 0.083160 0.083459 0.086917 0.109116 0.122435 0.123374 0.123972 0.125679 0.125508 0.123715 0.117227 0.118507 0.124569 0.148945 0.161026 0.160215 0.150141 0.140535 0.122392
    0.084476 0.068895 0.066591 0.066040 0.066935 0.067003 0.067244 0.070030 0.087916 0.098648 0.099404 0.099886 0.101262 0.101124 0.099679 0.094451 0.095483 0.100367 0.120008 0.129742 0.129088 0.120971 0.113232 0.098613
    0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
    0.039942 0.032574 0.031485 0.031225 0.031647 0.031680 0.031794 0.033111 0.041568 0.046642 0.047000 0.047227 0.047878 0.047813 0.047130 0.044658 0.045146 0.047455 0.056741 0.061343 0.061034 0.057196 0.053537 0.046626
    0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000
    0.029956 0.024431 0.023614 0.023418 0.023736 0.023760 0.023845 0.024833 0.031176 0.034981 0.035250 0.035420 0.035908 0.035860 0.035347 0.033493 0.033859 0.035591 0.042556 0.046008 0.045776 0.042897 0.040153 0.034969
    ];

